SELECT CustomerID, SalesOrderID, TotalDue 
FROM Sales.SalesOrderHeader;

SELECT COUNT(*) AS CountOfSales,
	SUM(TotalDue) AS Total
FROM Sales.SalesOrderHeader;

SELECT CustomerID, COUNT(*) AS CountOfSales, 
	SUM(TotalDue) AS Total
FROM Sales.SalesOrderHeader;




--Add a group by
SELECT CustomerID, COUNT(*) AS CountOfSales, 
	SUM(TotalDue) AS Total
FROM Sales.SalesOrderHeader
GROUP BY CustomerID;

SELECT YEAR(OrderDate) AS OrderYear, 
	COUNT(*) AS CountOfSales, 
	SUM(TotalDue) AS Total
FROM Sales.SalesOrderHeader
;

SELECT YEAR(OrderDate) AS OrderYear, 
	 COUNT(*) AS CountOfSales, 
	SUM(TotalDue) AS Total
FROM Sales.SalesOrderHeader
GROUP BY OrderDate;

SELECT YEAR(OrderDate) AS OrderYear, customerID,
	 COUNT(*) AS CountOfSales, 
	SUM(TotalDue) AS Total
FROM Sales.SalesOrderHeader
GROUP BY YEAR(OrderDate), customerID
ORDER BY CustomerID, OrderYear;

/*
FROM
WHERE
GROUP BY
HAVING
SELECT
ORDER BY

*/



SELECT YEAR(OrderDate) AS OrderYear, 
	CustomerID, COUNT(*) AS CountOfSales, 
	SUM(TotalDue) AS Total
FROM Sales.SalesOrderHeader
GROUP BY CustomerID,
	YEAR(OrderDate)
ORDER BY Total DESC;

SELECT OYR.OrderYear, 
	COUNT(*) AS CountOfSales, 
	SUM(TotalDue) AS Total
FROM Sales.SalesOrderHeader
CROSS APPLY(
	SELECT Year(OrderDate) AS OrderYear) AS OYR
GROUP BY OrderYear
ORDER BY OrderYear DESC;






SELECT YEAR(OrderDate) AS OrderYear, 
	CustomerID, COUNT(*) AS CountOfSales, 
	SUM(TotalDue) AS Total
FROM Sales.SalesOrderHeader
GROUP BY CustomerID,
	YEAR(OrderDate)
ORDER BY AVG(TotalDue);

SELECT COUNT(*), COUNT(Color), COUNT(DISTINCT COLOR)
from production.product;

CREATE TABLE #Test(Col1 INT, Col2 INT);

INSERT INTO #test(Col1, Col2)
VALUES(1,2),(1,2),(2,3),(Null,5);

SELECT AVG(CAST(Col1 AS FLOAT)), SUM(CAST(Col1 AS FLOAT))/Count(*)
FROM #Test


select DISTINCT color 
from Production.Product

/*
How does a query become an aggregate query?

Add one of these:
aggregate function
group by
having

*/

/*

FROM 
WHERE 
GROUP BY
HAVING
SELECT 
ORDER BY

SELECT 
FROM
WHERE
GROUP BY
HAVING 
ORDER BY

*/



--WHERE vs. HAVING
--Return only the customers who have placed
--over 3 orders within a year
SELECT YEAR(OrderDate) AS OrderYear, 
	CustomerID, COUNT(*) AS CountOfSales, 
	SUM(TotalDue) AS Total
FROM Sales.SalesOrderHeader
WHERE COUNT(*) > 3
GROUP BY CustomerID,
	YEAR(OrderDate);

SELECT YEAR(OrderDate) AS OrderYear, 
	CustomerID, COUNT(*) AS CountOfSales, 
	SUM(TotalDue) AS Total
FROM Sales.SalesOrderHeader
GROUP BY CustomerID,
	YEAR(OrderDate)
HAVING COUNT(*) > 3;

--Add a grand total to calculate a percent
SELECT YEAR(OrderDate) AS OrderYear, 
	SUM(TotalDue) AS YearTotal
FROM Sales.SalesOrderHeader
GROUP BY YEAR(OrderDate);

--Use a subquery
SELECT YEAR(OrderDate) AS OrderYear, 
	SUM(TotalDue) AS YearTotal,
	(SELECT SUM(TotalDue) FROM Sales.SalesOrderHeader) AS GrandTotal
	,
	FORMAT(SUM(TotalDue)/
		(SELECT SUM(TotalDue) FROM Sales.SalesOrderHeader),'P') AS PercentOfSales
FROM Sales.SalesOrderHeader
GROUP BY YEAR(OrderDate);

SELECT YEAR(OrderDate) AS OrderYear, 
	SUM(TotalDue) AS YearTotal,
	SUM(SUM(TotalDue)) OVER() AS GrandTotal,
	FORMAT(Sum(TotalDue)/SUM(SUM(TotalDue)) OVER (), 'P') AS PercentOfSales
FROM Sales.SalesOrderHeader
GROUP BY YEAR(OrderDate);

SELECT SalesOrderID, ORderDate, CustomerID, TotalDue, 
	SUM(totalDue) OVER(Partition By CustomerID) AS SubTotal 
FROM Sales.SalesOrderHeader;
