/*	Nebraska Code() Conference
	May 18, 2016
*/
USE AdventureWorks2014;
GO
BEGIN TRY  
	DROP INDEX Perf1 ON Sales.SalesOrderHeader;
END TRY
BEGIN CATCH
END CATCH;

BEGIN TRY  
	DROP INDEX Perf2 ON Sales.SalesOrderHeader;
END TRY
BEGIN CATCH
END CATCH;

BEGIN TRY  
	DROP INDEX Perf3 ON Sales.SalesOrderHeader;
END TRY
BEGIN CATCH
END CATCH;

BEGIN TRY  
	DROP INDEX Test2 ON Sales.SalesOrderHeader;
END TRY
BEGIN CATCH
END CATCH;


--Demo 0 The Stock Problem
--Be sure to run script to generate the StockHistory table.
--Change to the database where you have run the script
USE Indexes;
GO
SELECT * FROM StockHistory;

SELECT TickerSymbol, TradeDate, ClosePrice, LastPrice
FROM StockHistory AS O 
CROSS APPLY(
	SELECT TOP(1) ClosePrice AS LastPrice
	FROM StockHistory AS I 
	WHERE I.TickerSymbol = O.TickerSymbol
		AND O.TradeDate > I.TradeDate 
	ORDER BY I.TradeDate) AS C

--Don't do this at home
DBCC DROPCLEANBUFFERS

--Using window functions
SELECT TickerSymbol, TradeDate, ClosePrice, 
	LAG(ClosePrice) OVER(ORDER BY TradeDate) AS LastPrice
FROM StockHistory;

--Demo 1 Ranking Functions
USE AdventureWorks2014;
GO
--Get AdventureWorks from Codeplex

--Ranking functions introduced in 2005 with the OVER clause
SELECT  SalesOrderID, OrderDate, CustomerID, 
	ROW_NUMBER() OVER(ORDER BY SalesOrderID) AS RowNbr
FROM Sales.SalesOrderHeader;

--you can also partition the results
SELECT SalesOrderID, OrderDate, CustomerID, 
	ROW_NUMBER() OVER(Partition By CustomerID ORDER BY SalesOrderID) 
	AS RowNbr
FROM Sales.SalesOrderHeader;

--What's the difffence between ROW_NUMBER, RANK and DENSE_RANK?
SELECT SalesOrderID, OrderDate, CustomerID, 
	ROW_NUMBER() OVER(PARTITION BY CustomerID ORDER BY OrderDate) As RowNum,
	RANK() OVER(PARTITION BY CustomerID ORDER BY OrderDate) As Rnk,
	DENSE_RANK() OVER(PARTITION BY CustomerID ORDER BY OrderDate) As DenseRnk
FROM Sales.SalesOrderHeader
WHERE CustomerID = 11078;

--NTILE
SELECT SP.FirstName, SP.LastName,
	SUM(SOH.TotalDue) AS TotalSales, 
	NTILE(4) OVER(ORDER BY SUM(SOH.TotalDue)) * 1000 AS Bonus
FROM [Sales].[vSalesPerson] SP 
JOIN Sales.SalesOrderHeader SOH ON SP.BusinessEntityID = SOH.SalesPersonID 
WHERE SOH.OrderDate >= '2012-01-01' AND SOH.OrderDate < '2013-01-01'
GROUP BY FirstName, LastName;

--ROW_NUMBER is nondeterministic
SELECT SalesOrderID, OrderDate, ROW_NUMBER() OVER(ORDER BY OrderDate) AS RowNum
FROM Sales.SalesOrderHeader
ORDER BY OrderDate, SalesOrderID DESC;

SELECT SalesOrderID, OrderDate, ROW_NUMBER() OVER(ORDER BY OrderDate) AS RowNum
FROM Sales.SalesOrderHeader
ORDER BY SalesOrderID;

--How to get unordered row numbers
SELECT CustomerID, SalesOrderID, OrderDate, 
	ROW_NUMBER() OVER(ORDER BY (SELECT NULL)) AS RowNum
FROM Sales.SalesOrderHeader
ORDER BY CustomerID;

--Random 
SELECT CustomerID, SalesOrderID, OrderDate, 
	ROW_NUMBER() OVER(ORDER BY NEWID()) AS RowNum
FROM Sales.SalesOrderHeader
ORDER BY CustomerID;



--Top 
SELECT TOP(10) 
	CustomerID, 
	SalesOrderID, ROW_NUMBER() OVER(ORDER BY CustomerID) AS RowNum
FROM Sales.SalesOrderHeader
ORDER BY SalesOrderID;

--Distinct
SELECT DISTINCT CustomerID, ROW_NUMBER() OVER(ORDER BY CustomerID) AS RowNum
FROM Sales.SalesOrderHeader
ORDER BY CustomerID;


WITH Cust AS (
	SELECT DISTINCT CustomerID 
	FROM Sales.SalesOrderHeader)
SELECT CustomerID, ROW_NUMBER() OVER(ORDER BY CustomerID) AS RowNum
FROM Cust
ORDER BY CustomerID;

--Remove Duplicates
CREATE TABLE #temp(Col1 INT, Col2 INT);
INSERT INTO #temp(Col1,Col2)
VALUES(1,1),(1,1),(1,2),(1,3),(1,3),(1,3),(1,3);

SELECT Col1, Col2 FROM #temp;

SELECT Col1, Col2, 
	ROW_NUMBER() OVER(ORDER BY Col1) AS RowNbr
	FROM #temp;

SELECT Col1, Col2, 
	ROW_NUMBER() OVER(PARTITION BY Col1, Col2 ORDER BY Col1) AS RowNbr
	FROM #temp;

SELECT Col1, Col2, 
	ROW_NUMBER() OVER(PARTITION BY Col1, Col2 ORDER BY Col1) AS RowNbr
FROM #temp
WHERE ROW_NUMBER() OVER(PARTITION BY Col1, Col2 ORDER BY Col1) <> 1;

WITH Rows AS(
	SELECT Col1, Col2, 
	ROW_NUMBER() OVER(PARTITION BY Col1, Col2 ORDER BY Col1) AS RowNbr
	FROM #temp)
SELECT Col1, Col2, RowNbr 
FROM Rows 
WHERE RowNbr <> 1;

WITH Rows AS(
	SELECT Col1, Col2, 
	ROW_NUMBER() OVER(PARTITION BY Col1, Col2 ORDER BY Col1) AS RowNbr
	FROM #temp)
DELETE FROM Rows 
WHERE RowNbr <> 1;

SELECT Col1, Col2 FROM #temp;


--The first 4 orders in each year
;WITH Orders AS(
	SELECT CustomerID, SalesOrderID, OrderDate, 
		ROW_NUMBER() OVER(PARTITION BY YEAR(OrderDate) 
		ORDER BY OrderDate) AS RowNum, 
		YEAR(OrderDate) AS OrderYear
	FROM Sales.SalesOrderHeader)
SELECT CustomerID, SalesOrderID, OrderDate, OrderYear
FROM Orders
WHERE RowNum < 5;

--Islands
CREATE TABLE #Islands(Col1 INT NOT NULL ) ;

INSERT INTO #Islands (Col1) 
VALUES(1),(2),(3),(6),(8),(8),(9),(10),(11),(12),(12),(14),(15),(18),(19);

select * from #Islands
/* results should look like this
1,3
6,6
8,12
14,15
18,19
*/

--Step 1: add Row_Number
SELECT Col1, Row_Number() OVER(ORDER BY Col1) AS RowNum FROM #Islands;

--since duplicates, change to DENSE_RANK
--Step 2: look at the difference
SELECT Col1,DENSE_RANK() OVER(ORDER BY Col1) AS DnsRnk, 
	Col1 - DENSE_RANK() OVER(ORDER BY Col1) AS Diff
FROM #Islands;

--Step 3: Use min and Max
;WITH I AS(
	SELECT Col1, Col1 - DENSE_RANK() 
	OVER(ORDER BY Col1) AS Diff FROM #Islands)
SELECT MIN(Col1) AS FirstItem, MAX(Col1) AS LastItem 
FROM I 
GROUP BY Diff;

--Find gaps
--Step 1 compare to a number table
WITH Nums AS (
	SELECT ROW_NUMBER() OVER(ORDER BY (select null)) AS GapNum
	FROM sys.objects)
SELECT GapNum
FROM Nums 
WHERE GapNum NOT IN (SELECT Col1 FROM #Islands);

--Add a row number and move to CTE
WITH Nums AS (
	SELECT ROW_NUMBER() OVER(ORDER BY (select null)) AS GapNum
	FROM sys.objects),
GRPS AS(
	SELECT GapNum, ROW_NUMBER() OVER(ORDER BY GapNum) AS Grp
	FROM Nums 
	WHERE GapNum NOT IN (SELECT Col1 FROM #Islands))
SELECT GapNum, Grp
FROM GRPS;

--Subtract and Find min and max
WITH Nums AS (
	SELECT ROW_NUMBER() OVER(ORDER BY (select null)) AS GapNum
	FROM sys.objects),
GRPS AS(
	SELECT GapNum, GapNum - ROW_NUMBER() OVER(ORDER BY GapNum) AS Grp
	FROM Nums 
	WHERE GapNum NOT IN (SELECT Col1 FROM #Islands))
SELECT MIN(GapNum) GapStart,MAX(GapNum) AS GapEnd
FROM GRPS
GROUP BY Grp
ORDER BY MIN(GapNum);

--END Demo 1

--Demo 2 window aggregates
USE AdventureWorks2014;
GO

--Calculate aggregates without an aggregate query
--with window aggregate functions
SELECT ProductID, name, FinishedGoodsFlag
FROM Production.Product;


--Need a list of products and average list price
--This will not work
SELECT ProductID, name, ListPrice,
	COUNT(*)  CountOfProduct, 
	AVG(ListPrice) AS AvgListPrice
FROM Production.Product 
WHERE FinishedGoodsFlag = 1;

--Add a group by
SELECT ProductID, name, ListPrice,
	COUNT(*)  CountOfProduct,
	AVG(ListPrice) AS AvgListPrice
FROM Production.Product
WHERE FinishedGoodsFlag = 1
GROUP BY ProductID, name, ListPrice;

--Add OVER clause instead
SELECT ProductID, name, ListPrice,
	COUNT(*) OVER() CountOfProduct,
	AVG(ListPrice) OVER() AS AvgListPrice
FROM Production.Product
WHERE FinishedGoodsFlag = 1;

--Need subtotals by category
--Join to get categories
SELECT P.ProductID, P.name AS ProductName, 
	C.Name AS CategoryName, ListPrice,
	COUNT(*) OVER() CountOfProduct,
	AVG(ListPrice) OVER() AS AvgListPrice
FROM Production.Product AS P
JOIN Production.ProductSubcategory AS S 
	ON S.ProductSubcategoryID = P.ProductSubcategoryID
JOIN Production.ProductCategory AS C 
	ON C.ProductCategoryID = S.ProductCategoryID
WHERE FinishedGoodsFlag = 1;



--Partition by ProductCategoryID
SELECT P.ProductID, P.name AS ProductName, 
	C.Name AS CategoryName, ListPrice,
	COUNT(*) OVER(PARTITION BY C.ProductCategoryID) CountOfProduct,
	AVG(ListPrice) OVER(PARTITION BY C.ProductCategoryID) AS AvgListPrice
FROM Production.Product AS P
JOIN Production.ProductSubcategory AS S 
	ON S.ProductSubcategoryID = P.ProductSubcategoryID
JOIN Production.ProductCategory AS C 
	ON C.ProductCategoryID = S.ProductCategoryID
WHERE FinishedGoodsFlag = 1;


--Mix windows
SELECT P.ProductID, P.name AS ProductName, 
	C.Name AS CategoryName, ListPrice,
	COUNT(*) OVER(PARTITION BY C.ProductCategoryID) CountOfProduct,
	AVG(ListPrice) OVER(PARTITION BY C.ProductCategoryID) AS AvgListPrice,
	MIN(ListPrice) OVER() AS MinListPrice,
	MAX(ListPrice) OVER() AS MaxListPrice
FROM Production.Product AS P
JOIN Production.ProductSubcategory AS S 
	ON S.ProductSubcategoryID = P.ProductSubcategoryID
JOIN Production.ProductCategory AS C 
	ON C.ProductCategoryID = S.ProductCategoryID
WHERE FinishedGoodsFlag = 1;





--Add a Window Aggregate to an Aggreate query?
--Here is a typical query
SELECT CustomerID, SUM(TotalDue) AS CustTotal,AVG(TotalDue) AS CustAvg
FROM Sales.SalesOrderHeader
GROUP BY CustomerID;

--Add a grand total
--This will not work
SELECT CustomerID, SUM(TotalDue) AS CustTotal,
	AVG(TotalDue) AS CustAvg,
	SUM(TotalDue) OVER() AS GrandTotal
FROM Sales.SalesOrderHeader
GROUP BY CustomerID;

--The window function must follow the 
--same rules as select list
SELECT CustomerID, SUM(TotalDue) AS CustTotal,
	AVG(TotalDue) AS CustAvg,
	SUM(SUM(TotalDue)) OVER() AS GrandTotal
FROM Sales.SalesOrderHeader
GROUP BY CustomerID;




--Can you create your own Window functions?
--Add the dll to the location before running
--Yes!!
BEGIN TRY
	DROP AGGREGATE Median;
	DROP ASSEMBLY Median;
END TRY
BEGIN CATCH
END CATCH;

GO
CREATE ASSEMBLY Median FROM
 'C:\CLR\Median.dll' WITH PERMISSION_SET = SAFE; 

GO

CREATE Aggregate Median (@Value INT) RETURNS INT
EXTERNAL NAME Median.Median;

GO

WITH Orders AS (
	SELECT CustomerID, SUM(OrderQty) AS OrderQty, SOH.SalesOrderID 
	FROM Sales.SalesOrderHeader AS SOH
	JOIN Sales.SalesOrderDetail AS SOD ON SOH.SalesOrderID = SOD.SalesOrderDetailID
	GROUP BY CustomerID, SOH.SalesOrderID)
SELECT CustomerID, OrderQty, dbo.Median(OrderQty) OVER(PARTITION BY CustomerID) AS Median
FROM Orders
WHERE CustomerID IN (13011, 13012, 13019);

--End Demo 2

--Demo 3 Accumulating Aggregates
SELECT  SalesOrderID,OrderDate, CustomerID, TotalDue,
	SUM(TotalDue) OVER(PARTITION BY CustomerID ORDER BY SalesOrderID
		) AS CustomerRunningTotal
FROM Sales.SalesOrderHeader SOH
ORDER BY CustomerID, OrderDate;

USE Indexes;
GO

--The subscription problem
--Step 1, view the data 
SELECT * FROM Subscription;


--Step 2, counts based on Dates
SELECT COUNT(*) AS NewSubCount, 
	DateJoined 
FROM Subscription
GROUP BY DateJoined;

SELECT COUNT(*) AS CancellationCount,
	DateLeft 
FROM Subscription
GROUP BY DateLeft;

--Step 3 join these two queries
WITH Joined AS (
	SELECT COUNT(*) AS NewSubCount, 
		DateJoined 
	FROM Subscription
	GROUP BY DateJoined),
Cancelled AS (
	SELECT COUNT(*) AS CancellationCount,
		DateLeft 
	FROM Subscription
	GROUP BY DateLeft)
SELECT DateJoined, NewSubCount, CancellationCount
FROM Joined 
LEFT JOIN Cancelled ON Joined.DateJoined = Cancelled.DateLeft;


--Solution
WITH Joined AS (
	SELECT COUNT(*) AS NewSub, DateJoined 
	FROM Subscription 
	GROUP BY DateJoined),
 Cancelled AS
	(SELECT COUNT(*) AS Cancellation, DateLeft 
	FROM Subscription
	GROUP BY DateLeft)
SELECT DateJoined,	
	NewSub, Cancellation,
	SUM(NewSub - ISNULL(Cancellation,0)) OVER(ORDER BY DateJoined) AS CurrentCount
FROM JOINED 
LEFT JOIN Cancelled ON Joined.DateJoined = Cancelled.DateLeft;


--End Demo 3 

--Demo 4 Framing
USE AdventureWorks2014;
GO
SELECT  OrderDate, CustomerID, TotalDue,
	SUM(TotalDue) OVER(PARTITION BY CustomerID ORDER BY SalesOrderID 
		ROWS BETWEEN UNBOUNDED PRECEDING and CURRENT ROW) AS RunningTotal,
	SUM(TotalDue) OVER(PARTITION BY CustomerID ORDER BY SalesOrderID 
		ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS ReverseTotal
FROM Sales.SalesOrderHeader SOH
ORDER BY CustomerID, OrderDate;

--Can abbreviate
SELECT  OrderDate, CustomerID, TotalDue,
	SUM(TotalDue) OVER(PARTITION BY CustomerID ORDER BY SalesOrderID 
		ROWS UNBOUNDED PRECEDING ) AS RunningTotal,
	SUM(TotalDue) OVER(PARTITION BY CustomerID ORDER BY SalesOrderID 
		ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS ReverseTotal
FROM Sales.SalesOrderHeader SOH
ORDER BY CustomerID, OrderDate;

--Using range with a non-unique order by can give 
--possibly unexpected results
SELECT CustomerID, OrderDate, SalesOrderID, TotalDue, 
	SUM(TotalDue) OVER(PARTITION BY CustomerID ORDER BY OrderDate) AS RunningTotal,
	SUM(TotalDue) OVER(PARTITION BY CustomerID ORDER BY OrderDate
		ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) AS RunningTotalWithFrame
FROM Sales.SalesOrderHeader 
WHERE CustomerID IN ('11433','11078','18758');

--Solution: use unique order by
--preferably specify the frame

--Same problem with old method
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue, 
	(SELECT SUM(TotalDue) 
	FROM Sales.SalesOrderHeader
	WHERE CustomerID = a.CustomerID
		AND OrderDate <= a.OrderDate) AS RunningTotal
FROM Sales.SalesOrderHeader a
WHERE CustomerID IN ('11433','11078','18758');


--specify a number of rows
SELECT CustomerID, OrderDate, SalesOrderID, TotalDue,
	SUM(TotalDue) 
	OVER(ORDER BY SalesOrderID 
	ROWS BETWEEN 2 PRECEDING AND CURRENT ROW)  
	AS Prev2_Orders
FROM Sales.SalesOrderHeader
Order By SalesOrderID ;

--Rolling average
WITH Orders AS (
	SELECT OrderDate, Sum(OrderQty) AS OrderQty 
	FROM Sales.SalesOrderHeader AS SOH 
	INNER JOIN Sales.SalesOrderDetail AS SOD 
		ON SOH.SalesOrderID = SOD.SalesOrderID
	GROUP BY OrderDate)
SELECT OrderDate, ORderQty,AVG(OrderQty) OVER(ORDER BY OrderDate
	ROWS BETWEEN 5 PRECEDING AND 5 FOLLOWING) AS MovingAvg
FROM Orders
ORDER BY OrderDate;



--End Demo 4


--Demo 5 LAG and LEAD

SELECT CustomerID, SalesOrderID, OrderDate, 
	 LAG(SalesOrderID) 
		OVER( PARTITION BY CustomerID ORDER BY SalesOrderID) 
			AS PreviousOrder,
	 LEAD(SalesOrderID) OVER(PARTITION BY CustomerID ORDER BY 
		SalesOrderID) AS NextOrder
    ,DATEDIFF(d,LAG(OrderDate) OVER(PARTITION BY CustomerID ORDER BY SalesOrderID),
	 	OrderDate) AS DaysSinceLast
     ,DATEDIFF(d,OrderDate,LEAD(OrderDate) OVER(PARTITION BY CustomerID ORDER BY SalesOrderID))
		AS DaysUntilNext
FROM Sales.SalesOrderHeader 
ORDER BY CustomerID,SalesOrderID;




--Optional OFFSET and default parameters
SELECT CustomerID, SalesOrderID, OrderDate, 
	LAG(OrderDate,2,'2001-01-01') 
	OVER(PARTITION BY CustomerID ORDER BY OrderDate) AS Back2Orders 
FROM Sales.SalesOrderHeader
ORDER BY CustomerID DESC; 

USE Indexes;
GO
SELECT * FROM StockHistory;

SELECT TickerSymbol, TradeDate, ClosePrice, 
	ClosePrice - LAG(ClosePrice) OVER(PARTITION BY TickerSymbol ORDER BY TradeDate) AS PriceChange
FROM StockHistory
ORDER BY TickerSymbol;

USE AdventureWorks2014;
GO
WITH Sales AS (
	SELECT YEAR(OrderDate) AS OrderYear, MONTH(OrderDate) AS OrderMonth, 
		SUM(TotalDue) AS TotalSales
	FROM Sales.SalesOrderHeader
	GROUP BY YEAR(OrderDate), MONTH(OrderDate)
	)
SELECT OrderYear, OrderMonth,TotalSales,
	LAG(TotalSales, 1) OVER(PARTITION BY OrderMonth ORDER BY OrderYear) AS LastYear
FROM Sales
ORDER BY OrderYear, OrderMonth;






--FRAME suported -- RANGE BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW by default
SELECT CustomerID, OrderDate, TotalDue ,
      FIRST_VALUE(TotalDue) OVER(PARTITION BY CustomerID 
	  ORDER BY SalesOrderID) AS FirstTotalDue, 
	  FIRST_VALUE(OrderDate) OVER(PARTITION BY CustomerID 
	  ORDER BY SalesOrderID) AS FirstOrderDate 
FROM Sales.SalesOrderHeader
ORDER BY CustomerID, SalesOrderID;

--Last Value
SELECT CustomerID, OrderDate, TotalDue ,
      LAST_VALUE(TotalDue) OVER(PARTITION BY CustomerID 
	  ORDER BY SalesOrderID) AS LastTotalDue, 
	  LAST_VALUE(OrderDate) OVER(PARTITION BY CustomerID 
	  ORDER BY SalesOrderID) AS LastOrderDate 
FROM Sales.SalesOrderHeader
ORDER BY CustomerID, SalesOrderID;




--What is wrong? 
--The default frame only goes to current row
SELECT CustomerID, OrderDate, TotalDue ,
      LAST_VALUE(TotalDue) OVER(PARTITION BY CustomerID 
	  ORDER BY SalesOrderID) AS LastTotalDue, 
	  LAST_VALUE(OrderDate) OVER(PARTITION BY CustomerID 
	  ORDER BY SalesOrderID) AS LastOrderDate 
FROM Sales.SalesOrderHeader
ORDER BY CustomerID, SalesOrderID;

--The default frame only goes to current row
SELECT CustomerID, OrderDate, TotalDue ,
      LAST_VALUE(TotalDue) OVER(PARTITION BY CustomerID 
	  ORDER BY SalesOrderID
	  ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS LastTotalDue, 
	  LAST_VALUE(OrderDate) OVER(PARTITION BY CustomerID 
	  ORDER BY SalesOrderID ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS LastOrderDate 
FROM Sales.SalesOrderHeader
ORDER BY CustomerID, SalesOrderID;
--End Demo 5

--Demo 6 Statistical functions
/*
PERCENT_RANK = My score is higher than 89% of the scores
CUME_DIST = My score is at 90%
*/


CREATE TABLE #MonthlyTempsStl(MNo Int, MName varchar(15), AvgHighTemp INT)

INSERT INTO #MonthlyTempsStl
VALUES(1,'Jan',40),(2,'Feb',45),(3,'Mar',55),(4,'Apr',67),(5,'May',77),(6,'Jun',85),
	(7,'Jul',89),(8,'Aug',88),(9,'Sep',81),(10,'Oct',69),(11,'Nov',56),(12,'Dec',43)

SELECT MName, AvgHighTemp, RANK() OVER(ORDER BY AvgHighTemp) AS Rnk,
	PERCENT_RANK() OVER(ORDER BY AvgHighTemp) * 100.0 AS PR,
	CUME_DIST() OVER(ORDER BY AvgHighTemp) * 100.0 AS CD
FROM #MonthlyTempsStl;

--What is the median temp?
SELECT MName, AvgHighTemp,
	PERCENTILE_CONT(0.5) WITHIN GROUP(ORDER BY AvgHighTemp) OVER() AS Median1,
	PERCENTILE_DISC(0.5) WITHIN GROUP(ORDER BY AvgHighTemp) OVER() AS Median2
FROM #MonthlyTempsStl;

--End Demo 6

--Begin Performance
--Demo 7 Execution Plan
SELECT c.CustomerID, soh.SalesOrderID, p.name, sod.OrderQty
FROM sales.customer as c 
join sales.SalesOrderHeader as soh on c.CustomerID = soh.CustomerID
join sales.SalesOrderDetail as sod on soh.SalesOrderID = sod.SalesOrderID
join production.product  as p on sod.productid = p.productid;



--End Demo 7

--Demo 8 Statistics IO and Time
SET STATISTICS IO ON

SELECT c.CustomerID, soh.SalesOrderID, p.name, sod.OrderQty
FROM sales.customer as c 
join sales.SalesOrderHeader as soh on c.CustomerID = soh.CustomerID
join sales.SalesOrderDetail as sod on soh.SalesOrderID = sod.SalesOrderID
join production.product  as p on sod.productid = p.productid;



SET STATISTICS IO OFF
SET STATISTICS TIME ON

SELECT c.CustomerID, soh.SalesOrderID, p.name, sod.OrderQty
FROM sales.customer as c 
join sales.SalesOrderHeader as soh on c.CustomerID = soh.CustomerID
join sales.SalesOrderDetail as sod on soh.SalesOrderID = sod.SalesOrderID
join production.product  as p on sod.productid = p.productid;

SET STATISTICS TIME OFF

--http://Statisticsparser.com

--End Demo 8

--Demo 9 POC index
SET STATISTICS IO ON
--turn on execution plan
PRINT '--Ranking'
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue, 
	ROW_NUMBER() 
	OVER(PARTITION BY CustomerID ORDER BY SalesOrderID) AS RowNum
FROM Sales.SalesOrderHeader;

Print '--Windows Aggregate function'
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	SUM(TotalDue) OVER(PARTITION BY CustomerID) AS SubTotal
FROM Sales.SalesOrderHeader;

Print '--Running total'
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	SUM(TotalDue) 
	OVER(PARTITION BY CustomerID ORDER BY SalesOrderID) AS RunningTotal
FROM Sales.SalesOrderHeader;

Print '--Offset function'
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	LAG(SalesOrderID) 
	OVER(PARTITION BY CustomerID ORDER BY SalesOrderID) AS PrevOrder
FROM Sales.SalesOrderHeader;

CREATE NONCLUSTERED INDEX Perf1 ON Sales.SalesOrderHeader
	(CustomerID, SalesOrderID) INCLUDE(OrderDate,TotalDue);

PRINT '--Ranking'
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue, 
	ROW_NUMBER() 
	OVER(PARTITION BY CustomerID ORDER BY SalesOrderID) AS RowNum
FROM Sales.SalesOrderHeader;

Print '--Windows Aggregate function'
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	SUM(TotalDue) OVER(PARTITION BY CustomerID) AS SubTotal
FROM Sales.SalesOrderHeader;

Print '--Running total'
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	SUM(TotalDue) 
	OVER(PARTITION BY CustomerID ORDER BY SalesOrderID) AS RunningTotal
FROM Sales.SalesOrderHeader;

Print '--Offset function'
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	LAG(SalesOrderID) 
	OVER(PARTITION BY CustomerID ORDER BY SalesOrderID) AS PrevOrder
FROM Sales.SalesOrderHeader;

--Descending order
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue, 
	ROW_NUMBER() 
	OVER(PARTITION BY CustomerID ORDER BY SalesOrderID DESC) AS RowNum
FROM Sales.SalesOrderHeader;


CREATE INDEX Perf2 ON Sales.SalesOrderHeader
	(CustomerID, SalesOrderID DESC) INCLUDE(OrderDate, TotalDue);

SELECT CustomerID, SalesOrderID, OrderDate, TotalDue, 
	ROW_NUMBER() OVER(PARTITION BY CustomerID ORDER BY SalesOrderID DESC) AS RowNum
FROM Sales.SalesOrderHeader
ORDER BY CustomerID, SalesOrderID;

--End Demo 9

--Demo 10 Framining
--Applies to accumulating aggregates and FIRST_VALUE and LAST_VALUE
--Default frame
--Compare these 3
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue, 
	SUM(TotalDue) OVER(PARTITION BY CustomerID ORDER BY SalesOrderID) 
	AS RunningTotal
FROM Sales.SalesOrderHeader;

--RANGE
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue, 
	SUM(TotalDue) OVER(PARTITION BY CustomerID ORDER BY SalesOrderID
		RANGE BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) AS RunningTotal
FROM Sales.SalesOrderHeader;

--Change to ROWS
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue, 
	SUM(TotalDue) OVER(PARTITION BY CustomerID ORDER BY SalesOrderID
		ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) AS RunningTotal
FROM Sales.SalesOrderHeader;

--Offset function
SELECT CustomerID, SalesOrderID, OrderDate, 
	FIRST_VALUE(OrderDate) 
		OVER(PARTITION BY CustomerID ORDER BY SalesOrderID) AS FirstOrderDate
FROM Sales.SalesOrderHeader;

SELECT CustomerID, SalesOrderID, OrderDate, 
	FIRST_VALUE(OrderDate) 
	OVER(PARTITION BY CustomerID ORDER BY SalesOrderID 
		ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) AS FirstOrderDate
FROM Sales.SalesOrderHeader;

--End Demo 10

--Demo 11 Complex queries
SELECT SOD.SalesOrderID, P.Color, 
	ROW_NUMBER() OVER(PARTITION BY Color ORDER BY SalesOrderID) AS RowNum
FROM Sales.SalesOrderDetail AS SOD
JOIN Production.Product AS P ON SOD.ProductID = P.ProductID;

--Aggregate before using window aggregate
SELECT YEAR(OrderDate) AS OrderYear, SUM(TotalDue) AS TotalSales, 
	SUM(TotalDue)/SUM(SUM(TotalDue))OVER() * 100 AS PercentOfSales
FROM Sales.SalesOrderHeader
GROUP BY YEAR(OrderDate);

WITH YearlySales AS (
	SELECT YEAR(OrderDate) AS OrderYear,
		SUM(TotalDue) AS TotalSales 
	FROM Sales.SalesOrderHeader
	GROUP BY YEAR(OrderDate))
SELECT OrderYear, TotalSales, 
	TotalSales/
		SUM(TotalSales) OVER() AS PercentOfSales
FROM YearlySales;

--Traditional method
WITH Sales AS (
	SELECT SUM(TotalDue) AS GrandTotal
	FROM Sales.SalesOrderHeader
	)
SELECT YEAR(OrderDate) AS OrderYear,
	SUM(TotalDue) AS YearlyTotal,
	SUM(totalDue)/Grandtotal * 100 AS PercentOfSales
FROM Sales.SalesOrderHeader AS SOH
CROSS JOIN Sales
GROUP BY YEAR(OrderDate), Sales.GrandTotal;

--Window is reusable
SELECT CustomerID, SalesOrderID, TotalDue, 
	SUM(TotalDue) OVER(PARTITION BY CustomerID) AS SubTotal
FROM Sales.SalesOrderHeader;

SELECT CustomerID, SalesOrderID, TotalDue, 
	SUM(TotalDue) OVER(PARTITION BY CustomerID) AS SubTotal,
	AVG(TotalDue) OVER(PARTITION BY CustomerID) AS AvgOrder
FROM Sales.SalesOrderHeader;

--Demo 12 Performance comparisons

--Lag
--Old method
USE Indexes;
GO
SELECT TickerSymbol, TradeDate, A.ClosePrice, PrevDate.ClosePrice,
	A.ClosePrice - PrevDate.ClosePrice AS ClosePriceDif
FROM StockHistory A
OUTER APPLY(
	SELECT TOP(1) ClosePrice 
	FROM StockHistory B
	WHERE b.TickerSymbol = A.TickerSymbol
		AND B.TradeDate < A.TradeDate
	ORDER BY TradeDate	) AS PrevDate
ORDER BY TickerSymbol, TradeDate;

SELECT TickerSymbol, TradeDate, ClosePrice, 
	ClosePrice - LAG(ClosePrice) 
	OVER(PARTITION BY TickerSymbol ORDER BY TradeDate) AS ClosePriceDIf
FROM StockHistory 
ORDER BY TickerSymbol, TradeDate ;


USE AdventureWorks2014;
GO
--Window aggregate
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	SUM(TotalDue) OVER(PARTITION BY CustomerID) AS CustTotal
FROM Sales.SalesOrderHeader;


--CTE method
;WITH Totals AS (
	SELECT CustomerID, SUM(TotalDue) AS CustTotal
	FROM Sales.SalesOrderHeader
	GROUP BY CustomerID)
SELECT Totals.CustomerID, SalesOrderID, OrderDate, TotalDue,
	CustTotal
FROM Sales.SalesOrderHeader 
JOIN Totals ON Totals.CustomerID = SalesOrderHeader.CustomerID;


--Correlated sub-query method
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	(SELECT SUM(TotalDue) 
	FROM Sales.SalesOrderHeader 
	WHERE CustomerID = a.CustomerID) AS CustTotal
FROM Sales.SalesOrderHeader a;

--2 calcs
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	SUM(TotalDue) OVER(PARTITION BY CustomerID) AS CustTotal,
	MIN(TotalDue) OVER(PARTITION BY CustomerID) AS MinTotal
FROM Sales.SalesOrderHeader;

--CTE
;WITH Totals AS (
	SELECT CustomerID, SUM(TotalDue) AS CustTotal, MIN(TotalDue) AS MinTotal
	FROM Sales.SalesOrderHeader
	GROUP BY CustomerID)
SELECT Totals.CustomerID, SalesOrderID, OrderDate, TotalDue,
	CustTotal, MinTotal
FROM Sales.SalesOrderHeader 
JOIN Totals ON Totals.CustomerID = SalesOrderHeader.CustomerID;

--Correlated subquery
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	(SELECT SUM(TotalDue) 
	FROM Sales.SalesOrderHeader 
	WHERE CustomerID = a.CustomerID) AS CustTotal,
	(SELECT MIN(TotalDue)
	FROM Sales.SalesOrderHeader
	WHERE CustomerID = a.CustomerID) AS MinTotal
FROM Sales.SalesOrderHeader a;







--Running total comparison
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	SUM(TotalDue) OVER(PARTITION BY CustomerID ORDER BY SalesOrderID
			ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) AS RunningTotal
FROM Sales.SalesOrderHeader;

--Correlated sub-query method
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	(SELECT SUM(TotalDue) 
	FROM Sales.SalesOrderHeader
	WHERE CustomerID = a.CustomerID AND SalesOrderID < a.SalesOrderID) AS RunningTotal
FROM Sales.SalesOrderHeader a;

--Join method
SELECT a.CustomerID, a.SalesOrderID, a.OrderDate, a.TotalDue,
	SUM(b.TotalDue) AS RunningTotal
FROM Sales.SalesOrderHeader a
JOIN Sales.SalesOrderHeader b on a.CustomerID = b.CustomerID 
	AND a.SalesOrderID >= b.SalesOrderID
GROUP BY  a.CustomerID, a.SalesOrderID, a.OrderDate, a.TotalDue;







