--Nebraska.Code() Conference
--Demos

--DEMO 1


/*CAUTION: Don't DBCC FREEPROCCACHE OR DBCC DROPCLEANBUFFERS
on a production server!
*/
--Settings can affect query run times!
USE [master];
GO
ALTER DATABASE [AdventureWorks2014] 
SET PARAMETERIZATION SIMPLE WITH NO_WAIT;
GO
USE AdventureWorks2014;
DBCC FREEPROCCACHE
GO
--With simple paramterization, 
--most queries are not paramterized
--and each gets it own plan
--this is the default behavior
SELECT COUNT(*), ProductID
FROM dbo.bigTransactionHistory 
WHERE TransactionDate = '12/31/2004'
GROUP BY ProductID;

SELECT COUNT(*), ProductID
FROM dbo.bigTransactionHistory 
WHERE TransactionDate = '1/1/2008'
GROUP BY ProductID;

--Change to forced
USE [master];
GO
ALTER DATABASE [AdventureWorks2014] 
SET PARAMETERIZATION FORCED WITH NO_WAIT;
GO
USE AdventureWorks2014;
DBCC FREEPROCCACHE
GO
SELECT COUNT(*), ProductID
FROM dbo.bigTransactionHistory 
WHERE TransactionDate = '12/31/2004'
GROUP BY ProductID;

--This query runs with plan used for first query
--it takes longer to run since this is not the optimum plan
--for this query
SELECT COUNT(*), ProductID
FROM dbo.bigTransactionHistory 
WHERE TransactionDate = '1/1/2008'
GROUP BY ProductID;

--Query hints can affect query run time
--But use sparingly!!!!
USE AdventureWorks2014;
DBCC FREEPROCCACHE
GO
SELECT COUNT(*), ProductID
FROM dbo.bigTransactionHistory 
WHERE TransactionDate = '12/31/2004'
GROUP BY ProductID 
OPTION (RECOMPILE);

--Even though forced paramterization is on,
--the recompile hint causes a new plan to be created
SELECT COUNT(*), ProductID
FROM dbo.bigTransactionHistory 
WHERE TransactionDate = '1/1/2008'
GROUP BY ProductID
OPTION (RECOMPILE);


--Indexes can affect runtime
DROP INDEX [ix_TransactionDate] ON [dbo].[bigTransactionHistory];
CREATE INDEX [ix_TransactionDate] ON [dbo].[bigTransactionHistory]
(TransactionDate) INCLUDE(ProductID);

DBCC FREEPROCCACHE
GO
--a typical date
SELECT COUNT(*), ProductID
FROM dbo.bigTransactionHistory 
WHERE TransactionDate = '10/25/2007'
GROUP BY ProductID
OPTION (RECOMPILE);

--date with just two rows
SELECT COUNT(*), ProductID
FROM dbo.bigTransactionHistory 
WHERE TransactionDate = '12/31/2004'
GROUP BY ProductID 
OPTION (RECOMPILE);

--date with many rows
SELECT COUNT(*), ProductID
FROM dbo.bigTransactionHistory 
WHERE TransactionDate = '1/1/2008'
GROUP BY ProductID
OPTION (RECOMPILE);

GO
USE [master];
GO
ALTER DATABASE [AdventureWorks2014]
--set back to default 
SET PARAMETERIZATION SIMPLE WITH NO_WAIT;
GO
USE AdventureWorks2014;
GO
DBCC FREEPROCCACHE;
GO
--using sp_executesql to help prevent
--SQL injection and efficient use of cache
DECLARE @TransactionDate DATETIME = '12/31/2004';
DECLARE @param NVARCHAR(50) = N'@TransactionDate DATETIME';
DECLARE @command NVARCHAR(1000) = N'
SELECT COUNT(*), ProductID
FROM dbo.bigTransactionHistory 
WHERE TransactionDate = @TransactionDate
GROUP BY ProductID;'

EXEC sp_executesql @command,@param,@TransactionDate;
GO
DECLARE @TransactionDate DATETIME = '1/1/2008';
DECLARE @param NVARCHAR(50) = N'@TransactionDate DATETIME';
DECLARE @command NVARCHAR(1000) = N'
SELECT COUNT(*), ProductID
FROM dbo.bigTransactionHistory 
WHERE TransactionDate = @TransactionDate
GROUP BY ProductID;'
EXEC sp_executesql @command,@param,@TransactionDate;


--END DEMO 1


--DEMO 2
DBCC FREEPROCCACHE  --To clear the plan cache, don't do on production!

GO

SELECT  TOP(100) * FROM sales.SalesOrderHeader;


--To read the Plan Cache
SELECT qs.plan_handle,qs.execution_count, qs.total_logical_reads, qs.total_elapsed_time,
SUBSTRING(qt.TEXT,qs.statement_start_offset/2 +1,
(CASE WHEN qs.statement_end_offset = -1
			THEN LEN(CONVERT(NVARCHAR(MAX), qt.TEXT)) * 2
	  ELSE qs.statement_end_offset END - qs.statement_start_offset)/2) AS query_text 
FROM sys.dm_exec_query_stats AS qs WITH (NOLOCK)
CROSS APPLY sys.dm_exec_sql_text(qs.sql_handle) AS qt
WHERE qt.text like '%SalesOrderHeader%' AND qt.text NOT LIKE 'SELECT qs.execution%'
	AND qt.text NOT LIKE 'SELECT qs.plan%';

--how to clear one plan from cache
DBCC FREEPROCCACHE(0x06000C004E3B580B70A8913F0000000001000000000000000000000000000000000000000000000000000000);

SELECT qs.plan_handle,qs.execution_count, qs.total_logical_reads, qs.total_elapsed_time,
	qt.text
FROM sys.dm_exec_query_stats AS qs WITH (NOLOCK)
CROSS APPLY sys.dm_exec_sql_text(qs.sql_handle) AS qt
WHERE qt.text like '%SalesOrderHeader%' AND qt.text NOT LIKE 'SELECT qs.execution%'
	AND qt.text NOT LIKE 'SELECT qs.plan%';

--run a few times
SELECT TOP(100) * 
FROM Sales.SalesOrderHeader;

SELECT qs.execution_count, qs.total_logical_reads, qs.total_elapsed_time,
	qt.text
FROM sys.dm_exec_query_stats AS qs WITH (NOLOCK)
CROSS APPLY sys.dm_exec_sql_text(qs.sql_handle) AS qt
WHERE qt.text like '%SalesOrderHeader%' AND qt.text NOT LIKE 'SELECT qs.execution%'
	AND qt.text NOT LIKE 'SELECT qs.plan%';

--run a few times
SELECT TOP(100) * FROM Sales.SalesOrderHeader;

SELECT qs.execution_count, qs.total_logical_reads, qs.total_elapsed_time,
	qt.text
FROM sys.dm_exec_query_stats AS qs WITH (NOLOCK)
CROSS APPLY sys.dm_exec_sql_text(qs.sql_handle) AS qt
WHERE qt.text like '%SalesOrderHeader%' AND qt.text NOT LIKE 'SELECT qs.execution%'
	AND qt.text NOT LIKE 'SELECT qs.plan%';

--different ID
SELECT TOP(100) * FROM Sales.SalesOrderHeader
WHERE SalesOrderID = 43659;

SELECT qs.execution_count, qs.total_logical_reads, qs.total_elapsed_time,
	qt.text
FROM sys.dm_exec_query_stats AS qs WITH (NOLOCK)
CROSS APPLY sys.dm_exec_sql_text(qs.sql_handle) AS qt
WHERE qt.text like '%SalesOrderHeader%' AND qt.text NOT LIKE 'SELECT qs.execution%'
	AND qt.text NOT LIKE 'SELECT qs.plan%';

DBCC FREEPROCCACHE;
GO

EXEC SP_executesql N'SELECT * FROM Sales.SalesOrderHeader WHERE SalesOrderID = @SalesOrderID;',
	N'@SalesOrderID INT', 43659;


EXEC SP_executesql N'SELECT * FROM Sales.SalesOrderHeader WHERE SalesOrderID = @SalesOrderID;',
	N'@SalesOrderID INT', 43660;
	
	
SELECT qt.text,qs.execution_count, qs.total_logical_reads, qs.total_elapsed_time
	 
FROM sys.dm_exec_query_stats AS qs WITH (NOLOCK)
CROSS APPLY sys.dm_exec_sql_text(qs.sql_handle) AS qt
WHERE qt.text like '%SalesOrderHeader%' AND qt.text NOT LIKE 'SELECT qs.execution%'
	AND qt.text NOT LIKE 'SELECT qs.plan%';
--END DEMO 2


--DEMO 3
--DEPRICATED
--Returns query and plan in text
SET SHOWPLAN_TEXT ON; 
GO
SELECT COUNT(*) FROM dbo.bigTransactionHistory;

SET SHOWPLAN_TEXT OFF;
GO
--Returns plan with details
SET SHOWPLAN_ALL ON;
GO
SELECT COUNT(*) FROM dbo.bigTransactionHistory;

GO
SET SHOWPLAN_ALL OFF;
GO
--Run in new window
--RETURNS XML
SET SHOWPLAN_XML ON;
GO
SELECT COUNT(*) FROM dbo.bigTransactionHistory;


--use estimated plan
SELECT COUNT(*) FROM dbo.bigTransactionHistory;

--Toggle on execution plan
--Returns results and graphical plan
SELECT COUNT(*) FROM dbo.bigTransactionHistory;


CREATE TABLE #Table1(Col1 UNIQUEIDENTIFIER);
CREATE TABLE #Table2(Col1 UNIQUEIDENTIFIER);

INSERT INTO #Table1 ( Col1 )
SELECT NEWID() FROM Sys.objects;

INSERT INTO #Table2( Col1 )
SELECT NEWID() FROM sys.objects;


--How to improve this Query?
SELECT Col1 
FROM #Table1
UNION 
SELECT col1 
FROM #Table2;

SELECT Col1 
FROM #Table1
UNION ALL 
SELECT col1 
FROM #Table2;

SELECT OBJECT_NAME(p.OBJECT_ID) TableName,
        ps.partition_number, 
        ps.row_count
FROM sys.data_spaces  d 
     JOIN sys.indexes i 
     JOIN (SELECT DISTINCT OBJECT_ID
             FROM sys.partitions
             WHERE partition_number > 1) p
           ON i.OBJECT_ID = p.OBJECT_ID
           ON d.data_space_id = i.data_space_id
     JOIN sys.dm_db_partition_stats ps
           ON i.OBJECT_ID = ps.OBJECT_ID and i.index_id = ps.index_id
WHERE i.index_id < 2;

SELECT FirstName, LastName
FROM Person.Person
WHERE FirstName = 'Ken';

SELECT FirstName, LastName
FROM Person.Person
WHERE LastName = 'Meyer';


SELECT FirstName, LastName, PersonType
FROM Person.Person
WHERE LastName = 'Meyer';


--END DEMO 3


--BEGIN DEMO 4


--Statistics
--Toggle off execution plan
SET STATISTICS IO ON;
GO
SELECT COUNT(Quantity) 
FROM dbo.bigTransactionHistory;

SELECT COUNT(*)
FROM dbo.bigTransactionHistory;

SET STATISTICS IO OFF;
SET STATISTICS TIME ON
GO
SELECT COUNT(Quantity) 
FROM dbo.bigTransactionHistory;

SELECT COUNT(*)
FROM dbo.bigTransactionHistory;

SET STATISTICS TIME OFF;
--END DEMO 4

--DEMO 5
--The guessing game
--find a value in a HEAP
DECLARE @myNumber INT = CAST(RAND() * 1000 + 1 AS INT) ;
DECLARE @guess INT 
DECLARE @guessCount INT = 0

PRINT 'The number is ' + CAST(@myNumber AS VARCHAR);
DECLARE Numbers CURSOR FAST_FORWARD FOR
	SELECT ID FROM Heap 
OPEN Numbers 
FETCH NEXT FROM Numbers INTO @guess 
WHILE @myNumber <> @guess BEGIN 
	SET @guessCount += 1; 
	FETCH NEXT FROM Numbers INTO @guess;
	PRINT @guess;
END; 
PRINT 'I guessed the number in ' + CAST(@guessCount AS VARCHAR) + ' guesses!';
	
CLOSE Numbers;
DEALLOCATE Numbers;


GO
--Find the number in an index
--pick a random number 
DECLARE @maxNumber INT = 1000

DECLARE @myNumber INT = CAST(RAND() * @maxNumber + 1 AS INT) ;
PRINT 'The number is ' + CAST(@myNumber AS VARCHAR(10));

DECLARE @guess INT = @maxNumber/2
DECLARE @highGuess INT = @maxNumber
DECLARE @lowGuess INT = 1 
DECLARE @guessCount INT = 1

WHILE @guess <> @myNumber BEGIN 
	
	IF @myNumber > @guess BEGIN
		set @lowGuess = @guess; 
		SET @guess = (@highGuess + @guess)/2
	END
	ELSE BEGIN 
		SET @highGuess = @guess
		SET @guess = (@lowGuess + @guess)/2;
	END
	SET @guessCount += 1;
	Print @guess;
END ; 

print 'I found the number in ' + CAST(@guessCount AS VARCHAR) + ' guesses!';


--END DEMO 5


--DEMO 6
--Examine the plan cache for expensive queries
--This is from Glenn Berry's site
SELECT TOP (100) qs.execution_count, qs.total_rows, qs.last_rows, qs.min_rows, qs.max_rows,
qs.last_elapsed_time, qs.min_elapsed_time, qs.max_elapsed_time,
total_worker_time, total_logical_reads, 
SUBSTRING(qt.TEXT,qs.statement_start_offset/2 +1,
(CASE WHEN qs.statement_end_offset = -1
			THEN LEN(CONVERT(NVARCHAR(MAX), qt.TEXT)) * 2
	  ELSE qs.statement_end_offset END - qs.statement_start_offset)/2) AS query_text 
FROM sys.dm_exec_query_stats AS qs WITH (NOLOCK)
CROSS APPLY sys.dm_exec_sql_text(qs.sql_handle) AS qt
ORDER BY qs.execution_count DESC OPTION (RECOMPILE);

--Find Key lookups
--From Jonathan Kehayias
--https://www.sqlskills.com/blogs/jonathan/finding-key-lookups-inside-the-plan-cache/
WITH XMLNAMESPACES
   (DEFAULT 'http://schemas.microsoft.com/sqlserver/2004/07/showplan')
SELECT
    n.value('(@StatementText)[1]', 'VARCHAR(4000)') AS sql_text,
    i.value('(@PhysicalOp)[1]', 'VARCHAR(128)') AS PhysicalOp,
    i.value('(./IndexScan/Object/@Database)[1]', 'VARCHAR(128)') AS DatabaseName,
    i.value('(./IndexScan/Object/@Schema)[1]', 'VARCHAR(128)') AS SchemaName,
    i.value('(./IndexScan/Object/@Table)[1]', 'VARCHAR(128)') AS TableName,
    i.value('(./IndexScan/Object/@Index)[1]', 'VARCHAR(128)') as IndexName,
    STUFF((SELECT DISTINCT ', ' + cg.value('(@Column)[1]', 'VARCHAR(128)')
       FROM i.nodes('./OutputList/ColumnReference') AS t(cg)
       FOR  XML PATH('')),1,2,'') AS output_columns,
    STUFF((SELECT DISTINCT ', ' + cg.value('(@Column)[1]', 'VARCHAR(128)')
       FROM i.nodes('./IndexScan/SeekPredicates/SeekPredicateNew//ColumnReference') AS t(cg)
       FOR  XML PATH('')),1,2,'') AS seek_columns,
    i.value('(./IndexScan/Predicate/ScalarOperator/@ScalarString)[1]', 'VARCHAR(4000)') as Predicate,
    cp.usecounts
FROM (  SELECT plan_handle, query_plan
        FROM (  SELECT DISTINCT plan_handle
                FROM sys.dm_exec_query_stats WITH(NOLOCK)) AS qs
        OUTER APPLY sys.dm_exec_query_plan(qs.plan_handle) tp
      ) as tab (plan_handle, query_plan)
INNER JOIN sys.dm_exec_cached_plans AS cp 
    ON tab.plan_handle = cp.plan_handle
CROSS APPLY query_plan.nodes('/ShowPlanXML/BatchSequence/Batch/Statements/*') AS q(n)
CROSS APPLY n.nodes('.//RelOp[IndexScan[@Lookup="1"] and IndexScan/Object[@Schema!="[sys]"]]') as s(i)
OPTION(RECOMPILE, MAXDOP 1);
--END DEMO 6



--BEGIN DEMO 7
--Different plans based on statistics
DECLARE @TransactionDate DATETIME = '1/1/2004';
DECLARE @param NVARCHAR(50) = N'@TransactionDate DATETIME';
DECLARE @command NVARCHAR(1000) = N'
SELECT COUNT(*), ProductID
FROM dbo.bigTransactionHistory 
WHERE TransactionDate = @TransactionDate
GROUP BY ProductID;'

EXEC sp_executesql @command,@param,@TransactionDate;
GO
DECLARE @TransactionDate DATETIME = '12/31/2004';
DECLARE @param NVARCHAR(50) = N'@TransactionDate DATETIME';
DECLARE @command NVARCHAR(1000) = N'
SELECT COUNT(*), ProductID
FROM dbo.bigTransactionHistory 
WHERE TransactionDate = @TransactionDate
GROUP BY ProductID;'
SET @TransactionDate = '1/1/2008';
EXEC sp_executesql @command,@param,@TransactionDate;

GO

DECLARE @TransactionDate DATETIME = '1/1/2008';
DECLARE @param NVARCHAR(50) = N'@TransactionDate DATETIME';
DECLARE @command NVARCHAR(1000) = N'
SELECT COUNT(*), ProductID
FROM dbo.bigTransactionHistory 
WHERE TransactionDate = @TransactionDate
GROUP BY ProductID;'
EXEC sp_executesql @command,@param,@TransactionDate;

GO
DECLARE @TransactionDate DATETIME = '1/1/2007';
DECLARE @param NVARCHAR(50) = N'@TransactionDate DATETIME';
DECLARE @command NVARCHAR(1000) = N'
SELECT COUNT(*), ProductID
FROM dbo.bigTransactionHistory 
WHERE TransactionDate = @TransactionDate
GROUP BY ProductID OPTION(RECOMPILE);'
EXEC sp_executesql @command,@param,@TransactionDate;

--Key lookups
SELECT Quantity, ProductID, TransactionDate 
FROM [dbo].[bigTransactionHistory]
WHERE TransactionDate = '12/31/2004';

DBCC FREEPROCCACHE
go
SELECT Quantity, ProductID, TransactionDate 
FROM [dbo].[bigTransactionHistory]
WHERE TransactionDate = '1/1/2007';

DBCC FREEPROCCACHE;
GO
DECLARE @Date DATETIME = '12/31/2004';
SELECT Quantity, ProductID, TransactionDate 
FROM [dbo].[bigTransactionHistory]
WHERE TransactionDate = @Date;
--END DEMO 7


--Begin Demo 8
SELECT FirstName, LastName
FROM Person.Person 
WHERE LastName = 'Smith';

SELECT FirstName, LastName
FROM Person.Person 
WHERE LEFT(LastName,3) = 'Smi';

SELECT FirstName, LastName
FROM Person.Person 
WHERE LastName LIKE 'Smi%';

SELECT FirstName, LastName
FROM Person.Person 
WHERE LastName LIKE '%mith';

SELECT FirstName, LastName 
FROM Person.Person 
WHERE LastName NOT LIKE 'Smit%';

--Supposidly non-sargible, SQL can change it around
SELECT FirstName, LastName 
FROM Person.Person 
WHERE LastName NOT IN ('Smith');

SELECT FirstName, LastName 
FROM Person.Person 
WHERE LastName != 'Smith';

CREATE INDEX ix_Test ON Sales.SalesOrderHeader(OrderDate);

SELECT SalesOrderID, OrderDate
FROM Sales.SalesOrderHeader
WHERE OrderDate = '2012-01-01';

SELECT SalesOrderID, OrderDate
FROM Sales.SalesOrderHeader
WHERE YEAR(OrderDate) = 2012;

SELECT SalesOrderID, OrderDate
FROM Sales.SalesOrderHeader
WHERE OrderDate >= '2012/01/01' AND OrderDate < '2013/01/01';
--END Demo 8

--BEGIN Demo 9
CREATE TABLE #test(Col1 VARCHAR(10) NOT NULL PRIMARY KEY);
INSERT INTO #test(Col1) 
SELECT ROW_NUMBER() OVER(ORDER BY name)
FROM sys.objects;

DECLARE @ID INT = 7;
SELECT Col1
FROM #test WHERE Col1 = @ID;
GO
DECLARE @ID VARCHAR(10) = '7';
SELECT Col1
FROM #test WHERE Col1 = @ID;
--END DEMO 9

--BEGIN DEMO 10

--END DEMO 10
--BEGIN DEMO 11
GO
SET STATISTICS IO ON 
go
CREATE FUNCTION ufnGetQtySold(@ProductID INT, @StartDate DATETIME, 
	@EndDate DATETIME) RETURNS INT AS
BEGIN 
	DECLARE @Qty INT;
	SELECT @Qty = SUM(SOD.OrderQty)
	FROM Sales.SalesOrderDetail AS SOD 
	JOIN Sales.SalesOrderHeader AS SOH ON  SOH.SalesOrderID = SOD.SalesOrderID
	WHERE SOD.ProductID = @ProductID 
		AND OrderDate >= @StartDate AND OrderDate < @EndDate;
	RETURN @Qty;
END;

GO 
SELECT ProductID, Name, dbo.ufnGetQtySold(ProductID, '2012/01/01','2012/12/31') AS QtySold
FROM Production.Product;

--Meanwhile...
SELECT SUM(SOD.OrderQty)
FROM Sales.SalesOrderDetail AS SOD 
JOIN Sales.SalesOrderHeader AS SOH ON  SOH.SalesOrderID = SOD.SalesOrderID
WHERE SOD.ProductID =712
	AND OrderDate >= '2012/01/01' AND OrderDate < '2012/12/31';


--look at ufnGetContactInformation


GO

CREATE FUNCTION ufnGetTable(@ID INT) RETURNS TABLE AS
RETURN (
	SELECT TOP(3) SalesOrderDetailID
	FROM Sales.SalesOrderDetail
	WHERE SalesOrderID = @ID
);
GO

SELECT SalesOrderID, D.*
FROM Sales.SalesOrderHeader AS H 
CROSS APPLY dbo.ufnGetTable(SalesOrderID) AS D
ORDER BY SalesOrderID;

GO
WITH Details AS(
	SELECT SalesOrderID, SalesOrderDetailID, Row_Number() 
		OVER(PARTITION BY SalesOrderID ORDER BY SalesOrderDetailID) AS RowNum
	FROM Sales.SalesOrderDetail
)
SELECT H.SalesOrderID, D.SalesOrderDetailID 
FROM Sales.SalesOrderHeader AS H 
JOIN Details AS D ON D.SalesOrderID = H.SalesOrderID
WHERE RowNum <= 3;
	

GO
--END DEMO 11

--BEGIN DEMO 12
--The Subscription Problem
--Look at cursor soln in test database
--turn off execution plan
USE Test;
GO
usp_CursorSoln;
GO

WITH Joined AS (
	SELECT EOMONTH(DateJoined) AS TheMonth,
		COUNT(DateJoined) AS PeopleJoined
	FROM Registrations
	GROUP BY EOMONTH(DateJoined)),
 Cancelled AS (
	SELECT EOMONTH(DateLeft) AS TheMonth,
		COUNT(DateLeft) AS PeopleLeft
	FROM Registrations 
	GROUP BY EOMONTH(DateLeft))
SELECT JOINED.TheMonth AS TheMonth,JOINED.PeopleJoined, Cancelled.PeopleLeft,
	SUM(Joined.PeopleJoined - ISNULL(Cancelled.PeopleLeft,0)) 
	OVER(ORDER BY ISNULL(JOINED.TheMonth, Cancelled.TheMonth)) AS Subscriptions
FROM Joined 
LEFT JOIN Cancelled ON Joined.TheMonth = Cancelled.TheMonth;


--But, sometimes loops can help break extremely large
--transactions down to size
USE AdventureWorks2014;
GO
UPDATE dbo.bigTransactionHistory 
SET ActualCost = ActualCost * 1.10;

DECLARE @MaxID INT 
SELECT @MaxID= MAX(TransactionID) FROM dbo.bigTransactionHistory;
DECLARE @Count INT = 0
WHILE @Count <= @maxID BEGIN 
	PRINT @count;
	PRINT @count + 9999;
	PRINT '-----'
	UPDATE dbo.bigTransactionHistory
	SET ActualCost = ActualCost * 1.10
	WHERE TransactionID BETWEEN @Count AND @Count + 9999;
	SET @Count = @Count + 10000;
	
END;

















